unit conversion;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, StrUtils, Buttons, Menus, ZipForge;

type
  TConvert = class(TForm)
    parametres: TGroupBox;
    compresser: TCheckBox;
    ecraser_sans_confirm: TCheckBox;
    ProgressBar1: TProgressBar;
    source: TGroupBox;
    liste_fichiers: TTreeView;
    cmd_ajout_source: TBitBtn;
    cmd_suppression_source: TBitBtn;
    cmd_ajouter_msa: TBitBtn;
    Group_compte_rendu: TGroupBox;
    compte_rendu: TMemo;
    label_nombre_msa: TLabel;
    choix_nombre_msa: TComboBox;
    cmd_conversion_st: TBitBtn;
    cmd_conversion_msa: TBitBtn;
    menu_liste: TPopupMenu;
    raz_liste: TMenuItem;
    procedure cmd_ajout_sourceClick(Sender: TObject);
    procedure cmd_conversion_stClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure cmd_ajouter_msaClick(Sender: TObject);
    procedure liste_fichiersClick(Sender: TObject);
    procedure cmd_suppression_sourceClick(Sender: TObject);
    procedure liste_fichiersKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure cmd_conversion_msaClick(Sender: TObject);
    procedure raz_listeClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Dclarations prives }
    procedure supprime_selection;
    function conversion_image_disque(index_fichier:integer;format_dest:string):integer;
    function creation_nom_destination(nom_source:string;format_dest:string):string;
    function choix_autre_nom_fichier_dest(nom_fichier:string):string;
  public
    { Dclarations publiques }
    procedure demande_conversion(format_dest:string);
  end;

var
  Convert: TConvert;

implementation

uses main, tout, traduction, config;

{$R *.dfm}

var
    nb_fich_liste:integer;


//Ajout de fichiers source  la liste
procedure TConvert.cmd_ajout_sourceClick(Sender: TObject);
var
    nb_ajout:integer;
    compteur_ajout:integer;
    compteur_liste:integer;
    existant:boolean;

begin
    MSA_Converter.selecfichier.title:=textes_conversion[0];
    MSA_Converter.selecfichier.filter:=textes_conversion[1]+'|'+textes_conversion[2]+'|'+textes_conversion[3]+'|'+textes_conversion[4]+'|'+textes_conversion[5]+'|'+textes_conversion[8];
    MSA_Converter.selecfichier.fileName:='';
    MSA_Converter.selecfichier.options:=[ofFileMustExist,ofPathMustExist,ofAllowMultiSelect,ofHideReadOnly];
    MSA_Converter.selecfichier.InitialDir:=rep_utilisateur;

    if MSA_Converter.selecfichier.Execute=true then
    begin
        rep_utilisateur:=extraire_repertoire(MSA_Converter.selecfichier.files[0]);
        nb_ajout:=MSA_Converter.selecfichier.files.Count;
        liste_fichiers.Items.BeginUpdate;
        for compteur_ajout:=0 to nb_ajout-1 do
        begin
            //Vrifie que le fichier  ajouter n'est pas dj dans la liste
            existant:=false;
            for compteur_liste:=0 to nb_fich_liste-1 do
                if MSA_Converter.selecfichier.files[compteur_ajout]=liste_fichiers.Items[compteur_liste].Text
                    then existant:=true;
            //Ajout du fichier dans la liste
            if existant=false then liste_fichiers.Items.add(nil,MSA_Converter.selecfichier.files[compteur_ajout]);
        end;
        liste_fichiers.Items.EndUpdate;
        liste_fichiers.Items.AlphaSort(true);
    end;
    nb_fich_liste:=liste_fichiers.Items.Count;
end;

//Initialisation
procedure TConvert.FormCreate(Sender: TObject);
begin
    lit_ini_conversion;
    traduction_textes_conversion;
    cmd_ajouter_msa.Enabled:=false;
    compresser.Checked:=true;
end;

//Conversion d'une image disque
//Rsultat
// 0:Echec
// 1:Conversion russie
// 2:Pas de conversion - deuxime partie d'un MSA splitt  reconstituer
// 3:Pas de conversion - Format source=Format destination
// 4:Annulation de l'utilisateur
function TConvert.conversion_image_disque(index_fichier:integer;format_dest:string):integer;
var
    fichier_source_1:imagedisk;
    fichier_source_2:imagedisk;
    fichier_dest:imagedisk;

    nom_fich_source:string;
    nom_temp:string;

    autor_sauve:boolean;
    resultat_conversion:boolean;

    pointeur:integer;
    nb_fichiers_msa:integer;
    msa_debut:integer;
    msa_fin:integer;

begin
    result:=1;
    if liste_fichiers.Items[index_fichier].Parent=nil then
    begin
        autor_sauve:=true;
        resultat_conversion:=true;
        nb_fichiers_msa:=0;

        nom_fich_source:=liste_fichiers.Items[index_fichier].Text;
        fichier_dest.nomfichier:=creation_nom_destination(nom_fich_source,format_dest);

        fichier_source_1.nomfichier:=nom_fich_source;

        if lowercase(extraire_type_fichier(fichier_source_1.nomfichier))='zip' then fichier_source_1.sorte:='zip'
        else begin
            charge_image_disque(@fichier_source_1);
            lire_infos_image_disque(@fichier_source_1,true);
        end;

        //Vrifie que les formats source et destination soient bien diffrents
        if ((fichier_source_1.sorte=format_dest) and (format_dest='st') or
            ((fichier_source_1.sorte=format_dest) and (liste_fichiers.Items[index_fichier].HasChildren=false)) and (format_dest='msa'))
                then result:=3
        else if (fichier_source_1.fichier_ok=true) or (fichier_source_1.sorte='zip') then
        begin

        //Premire tape : Conversion du fichier source en fichier format ST

            nom_temp:=fichier_dest.nomfichier;
            fichier_dest.nomfichier:='msatemp.st';

            //format fichier source = MSA
            if fichier_source_1.sorte='msa' then
            begin
                resultat_conversion:=conversion_msa_vers_st(@fichier_source_1,@fichier_dest);
                if liste_fichiers.Items[index_fichier].HasChildren then
                begin
                    fichier_source_2.nomfichier:=liste_fichiers.Items[index_fichier].getfirstchild.Text;
                    charge_image_disque(@fichier_source_2);
                    lire_infos_image_disque(@fichier_source_2,true);
                    if fichier_source_2.fichier_ok=true then
                    begin
                        pointeur:=length(fichier_dest.donnees);
                        resultat_conversion:=conversion_msa_vers_st(@fichier_source_2,@fichier_temp);
                        setlength(fichier_dest.donnees,pointeur+length(fichier_temp.donnees));
                        copymemory(@fichier_dest.donnees[pointeur],@fichier_temp.donnees[0],length(fichier_temp.donnees)+1);
                    end
                    else begin
                        autor_sauve:=false;
                        result:=0;
                    end;
                end;
            end

            //format fichier source = STT
            else if fichier_source_1.sorte='stt' then
                resultat_conversion:=conversion_stt_vers_st(@fichier_source_1,@fichier_dest)

            //format fichier source = DIM
            else if fichier_source_1.sorte='dim' then
                resultat_conversion:=conversion_dim_vers_st(@fichier_source_1,@fichier_dest)

            //format fichier source = ST
            else if fichier_source_1.sorte='st' then
            begin
                setlength(fichier_dest.donnees,length(fichier_source_1.donnees));
                copymemory(@fichier_dest.donnees[0],@fichier_source_1.donnees[0],length(fichier_source_1.donnees));
            end

            //format fichier source = ZIP
            else if fichier_source_1.sorte='zip' then
                resultat_conversion:=conversion_zip_vers_st(fichier_source_1.nomfichier,@fichier_dest);

           if resultat_conversion=true then
           begin
                lire_infos_image_disque(@fichier_dest,false);
                fichier_dest.nomfichier:=nom_temp;

            //Deuxime tape : Conversion du fichier ST source en fichier format MSA si demand

                if format_dest='msa' then
                begin
                    nb_fichiers_msa:=choix_nombre_msa.ItemIndex+1;
                    if nb_fichiers_msa=1 then conversion_st_vers_msa(@fichier_dest,@fichier_dest,fichier_dest.piste_depart,fichier_dest.piste_fin)
                    else begin
                        nom_temp:=leftstr(fichier_dest.nomfichier,length(fichier_dest.nomfichier)-4);
                        fichier_dest.nomfichier:=nom_temp+'_a.msa';
                        fichier_temp.nomfichier:=nom_temp+'_b.msa';
                        msa_fin:=fichier_dest.piste_fin;
                        msa_debut:=(msa_fin-fichier_dest.piste_depart) shr 1;
                        conversion_st_vers_msa(@fichier_dest,@fichier_temp,msa_debut,msa_fin);
                        msa_fin:=msa_debut-1;
                        msa_debut:=fichier_dest.piste_depart;
                        conversion_st_vers_msa(@fichier_dest,@fichier_dest,msa_debut,msa_fin);
                    end;
                    lire_infos_image_disque(@fichier_dest,false);
                end;

            //Troisime tape : Sauvegarde du fichier converti

                if (fichier_source_1.sorte<>'zip') and (fileexists(fichier_dest.nomfichier)=true) and (ecraser_sans_confirm.Checked=false) then
                begin
                    nom_temp:=choix_autre_nom_fichier_dest(fichier_dest.nomfichier);
                    If nom_temp<>'' then
                    begin
                        fichier_dest.nomfichier:=nom_temp;
                        fichier_dest.nomfichier_zip:=nom_zip(fichier_dest.nomfichier)
                    end
                    else begin
                        autor_sauve:=false;
                        result:=4;
                    end;
                end;

                if autor_sauve then
                begin
                    //Sauvegarde
                    if fileexists(fichier_dest.nomfichier) then deletefile(fichier_dest.nomfichier);
                    sauve_image_disque(@fichier_dest);

                    If (compresser.Checked=true) and (fichier_source_1.sorte<>'zip') Then
                    begin
                        fichier_dest.nomfichier_zip:=nom_zip(fichier_dest.nomfichier);
                        if fileexists(fichier_dest.nomfichier_zip) then deletefile(fichier_dest.nomfichier_zip);
                        with msa_converter.zip do
                        begin
                            Options.StorePath := spNoPath;
                            filename :=fichier_dest.nomfichier_zip;
                            openarchive(fmCreate);
                            addfiles(fichier_dest.nomfichier);
                            closearchive;
                        end;
                        deletefile(fichier_dest.nomfichier);
                    end;

                    //Sauvegarde du deuxime fichier MSA si ncessaire
                    if (format_dest='msa') and (nb_fichiers_msa=2) then
                    begin
                        if fileexists(fichier_temp.nomfichier) then deletefile(fichier_temp.nomfichier);
                        sauve_image_disque(@fichier_temp);

                        If (compresser.Checked=true) then
                        begin
                            fichier_temp.nomfichier_zip:=nom_zip(fichier_temp.nomfichier);
                            if fileexists(fichier_temp.nomfichier_zip) then deletefile(fichier_temp.nomfichier_zip);
                            with msa_converter.zip do
                            begin
                                Options.StorePath := spNoPath;
                                filename :=fichier_temp.nomfichier_zip;
                                openarchive(fmCreate);
                                addfiles(fichier_temp.nomfichier);
                                closearchive;
                            end;
                            deletefile(fichier_temp.nomfichier);
                        end;
                    end;
                end;
            end
            else result:=0;

            if fileexists('msatemp.st') then deletefile('msatemp.st');

            setlength(fichier_source_1.donnees,0);
            setlength(fichier_source_2.donnees,0);
            setlength(fichier_dest.donnees,0);
            setlength(fichier_temp.donnees,0);
        end
        else result:=0;
    end
    else result:=2;
end;

//Cration du nom du fichier de destination avec l'extension adquate
function TConvert.creation_nom_destination(nom_source:string;format_dest:string):string;
var
    nom_rep:string;
    nom_fichier:string;
    extension:string;
    longueur:smallint;
    chartemp:char;
    meme_format:boolean;

begin
    nom_rep:=extraire_repertoire(nom_source);
    nom_fichier:=extraire_nom_fichier(nom_source);
    extension:=lowercase(extraire_type_fichier(nom_source));
    longueur:=length(nom_fichier);

    //Supprime l'extension d'origine
    dec(longueur,length(extension));
    nom_fichier:=leftstr(nom_fichier,longueur);

    if extension=lowercase(format_dest) Then meme_format:=true else meme_format:=false;

    //Mise en forme de la casse du nom
    if format_nom_dest=0 then
        nom_fichier:=lowercase(nom_fichier)
    else if format_nom_dest=1 then
    begin
        nom_fichier:=lowercase(nom_fichier);
        chartemp:=nom_fichier[1];
        if (ord(chartemp)>=97) and (ord(chartemp)<=122) then chartemp:=chr(ord(chartemp)-32);
        nom_fichier[1]:=chartemp;
    end else
        nom_fichier:=uppercase(nom_fichier);

    //Mise en forme de la casse de l'extension
    if format_ext_dest=0 then
        extension:=lowercase(format_dest)
    else if format_ext_dest=1 then
    begin
        extension:=lowercase(format_dest);
        chartemp:=extension[1];
        if (ord(chartemp)>=97) and (ord(chartemp)<=122) then chartemp:=chr(ord(chartemp)-32);
        extension[1]:=chartemp;
    end else
        extension:=uppercase(format_dest);

    //Ajoute l'extension au nom
    if meme_format Then
        result:=nom_rep+textes_conversion[9]+nom_fichier+extension
    else result:=nom_rep+nom_fichier+extension;
end;

//Boite de dialogue pour confirmer crasement fichier existant ou changement de nom
function TConvert.choix_autre_nom_fichier_dest(nom_fichier:string):string;
var
    choix:integer;

begin
    choix:=MessageDlg(textes_conversion[7] + nom_fichier, mtConfirmation, [mbYes, mbNo, mbCancel], 0);
    case choix of
        mrCancel:
            result:='';
        mrYes:
            result:=nom_fichier;
        mrNo:
            begin
                MSA_Converter.selecfichier.title:=textes_conversion[6];
                If lowercase(extraire_type_fichier(nom_fichier))='st' then MSA_Converter.selecfichier.Filter:=textes_conversion[2]
                    else MSA_Converter.selecfichier.filter:=textes_conversion[3];
                MSA_Converter.selecfichier.FileName:=nom_fichier;
                MSA_Converter.selecfichier.Options:=[ofHideReadOnly,ofPathMustExist,ofHideReadOnly];

                if MSA_Converter.selecfichier.Execute=false then result:=''
                else result:=MSA_Converter.selecfichier.FileName;
                end;
            end;
end;

//Fermeture de la fentre sur perte de la focalisation
procedure TConvert.FormDeactivate(Sender: TObject);
begin
    liste_fichiers.Items.BeginUpdate;
    liste_fichiers.items.Clear;
    liste_fichiers.Items.EndUpdate;
    ecrit_ini_conversion;
    close;
end;

//Active/Dsactive le bouton ajout deuxime fichier MSA
procedure TConvert.liste_fichiersClick(Sender: TObject);
begin
    cmd_ajouter_msa.Enabled:=false;
    if liste_fichiers.selectioncount=1 then
        if extraire_type_fichier(lowercase(liste_fichiers.Selected.Text))='msa' then
            if liste_fichiers.Selected.getFirstChild=nil then
                if liste_fichiers.Selected.Parent=nil then
                    cmd_ajouter_msa.Enabled:=true;
end;

//Ajoute la deuxime partie d'un fichier MSA
procedure TConvert.cmd_ajouter_msaClick(Sender: TObject);
begin
    MSA_Converter.selecfichier.title:=textes_conversion[0];
    MSA_Converter.selecfichier.filter:=textes_conversion[3];
    MSA_Converter.selecfichier.fileName:='';
    MSA_Converter.selecfichier.options:=[ofFileMustExist,ofPathMustExist,ofHideReadOnly];
    MSA_Converter.selecfichier.InitialDir:=rep_utilisateur;

    if MSA_Converter.selecfichier.Execute=true then
    begin
        rep_utilisateur:=extraire_repertoire(MSA_Converter.selecfichier.files[0]);
        liste_fichiers.Items.BeginUpdate;
        liste_fichiers.items.AddChild(liste_fichiers.Selected,MSA_Converter.selecfichier.files[0]);
        liste_fichiers.Items.AlphaSort(true);
        liste_fichiers.Items.EndUpdate;
        cmd_ajouter_msa.Enabled:=false;
    end;
    liste_fichiers.setfocus;
end;

//Demande la suppression des fichiers slectionns dans la liste
procedure TConvert.cmd_suppression_sourceClick(Sender: TObject);
begin
    supprime_selection;
end;

//Prise en compte des touches
procedure TConvert.liste_fichiersKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if key=VK_DELETE then supprime_selection;
end;

//Supprime les fichiers slectionns de la liste
procedure TConvert.supprime_selection;
begin
    if liste_fichiers.SelectionCount>0 then liste_fichiers.Selections[0].Delete;
    nb_fich_liste:=liste_fichiers.Items.Count;
end;

//Bouton de conversion vers format ST
procedure TConvert.cmd_conversion_stClick(Sender: TObject);
begin
    demande_conversion('st');
end;

//Bouton de conversion vers format MSA
procedure TConvert.cmd_conversion_msaClick(Sender: TObject);
begin
    demande_conversion('msa');
end;

//Lancement de la conversion des fichiers de la liste
procedure TConvert.demande_conversion(format_dest:string);
var
    compteur_liste:integer;
    resultat:integer;
    nb_conv_ok:integer;
    nb_conv_echouee:integer;
    nb_conv_non_effectuee:integer;
    nb_conv_annulee:integer;

begin
    progressBar1.Min:=0;
    progressBar1.Max:=nb_fich_liste;
    progressBar1.position:=progressBar1.min;
    compteur_liste:=0;
    compte_rendu.Lines.Clear;
    compte_rendu.Refresh;
    nb_conv_ok:=0;
    nb_conv_echouee:=0;
    nb_conv_non_effectuee:=0;
    nb_conv_annulee:=0;
    nb_fich_liste:=liste_fichiers.Items.Count;
    if nb_fich_liste>0 then
    repeat
        resultat:=conversion_image_disque(compteur_liste,format_dest);
        case resultat of
            //Conversion choue
            0: begin
                compte_rendu.Lines.Add('--- '+textes_conversion[11]+liste_fichiers.Items[compteur_liste].Text);
                inc(nb_conv_echouee);
            end;
            //Conversion effectue
            1: begin
                compte_rendu.Lines.Add(textes_conversion[12]+liste_fichiers.Items[compteur_liste].Text);
                inc(nb_conv_ok);
            end;
            //Conversion inutile
            3: begin
                compte_rendu.Lines.Add(textes_conversion[13]+liste_fichiers.Items[compteur_liste].Text);
                inc(nb_conv_non_effectuee);
            end;
            //Conversion annule
            4: begin
                compte_rendu.Lines.Add(textes_conversion[14]+liste_fichiers.Items[compteur_liste].Text);
                inc(nb_conv_annulee);
            end;
            2:
        end;
        inc(compteur_liste);
        progressBar1.position:=compteur_liste+1;
    until compteur_liste>=nb_fich_liste;

    //Affichage du rsum dans le compte-rendu
    compte_rendu.Lines.Add('');
    compte_rendu.Lines.Add(textes_conversion[10]);
    if nb_conv_echouee>0 then compte_rendu.Lines.Add(textes_conversion[11]+inttostr(nb_conv_echouee));
    if nb_conv_ok>0 then compte_rendu.Lines.Add(textes_conversion[12]+inttostr(nb_conv_ok));
    if nb_conv_non_effectuee>0 then compte_rendu.Lines.Add(textes_conversion[13]+inttostr(nb_conv_non_effectuee));
    if nb_conv_annulee>0 then compte_rendu.Lines.Add(textes_conversion[14]+inttostr(nb_conv_annulee));
end;

//Efface toute la liste de fichiers depuis le menu pop-up
procedure TConvert.raz_listeClick(Sender: TObject);
begin
    liste_fichiers.Items.Clear;
    nb_fich_liste:=liste_fichiers.Items.Count;
end;

//Efface toute la liste de fichiers  l'activation
procedure TConvert.FormActivate(Sender: TObject);
begin
    liste_fichiers.Items.Clear;
    nb_fich_liste:=liste_fichiers.Items.Count;
    compte_rendu.Clear;    
end;

end.
